/*
   Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
  
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <asm/io.h>

#include "ppar.h"

par_port::par_port(unsigned int paddr)
{
  addr = paddr;
  data_state = 0xff;
  outb(addr, data_state);
}

par_port::~par_port(void)
{
}

//	DATA port (+0)

void                     
par_port::SetData(unsigned int data)
{
  data_state = data;
  outb(addr, data_state);
}


void
par_port::SetDataBit(int bitnr, int new_state)
{
  if (new_state)
    data_state = data_state | (1 << bitnr);
  else
    data_state = data_state & !(1 << bitnr);
  outb(addr, data_state);
}

int
par_port::GetDataBit(int bitnr)
{
  return (data_state & (1 << bitnr));
}

//	CONTROL port (+PPAR_CONTROL)

void
par_port::SetControlBit(int bitnr, int new_state)
{
  if (new_state)
    ctl_state = ctl_state | (1 << bitnr);
  else
    ctl_state = ctl_state & ~(1 << bitnr);
  outb(addr+PPAR_CONTROL, ctl_state);
}

//	STATUS port (+PPAR_STATUS)

int
par_port::GetStatusBit(int bitnr)
{
  return (inb(addr+PPAR_CONTROL) & (1 << bitnr));
}
