/*
   Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
  
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ppar.h"

#define I2C_SDAOUT 	7		// bit 7 of dataport
#define I2C_SDAIN	PPAR_BUSY
#define I2C_SCLOUT	PPAR_SELECT
#define	I2C_SCLIN	PPAR_ERROR

#define	I2C_INV_SDAIN	1
#define I2C_INV_SDAOUT	1
#define I2C_INV_SCLOUT	1
#define I2C_INV_SCLIN	0

#define I2C_DEL_90	4700
#define I2C_DEL_91	4000
#define I2C_DEL_92	4700
#define I2C_DEL_93	4000


class i2c_port: public par_port {
  public:
    i2c_port(unsigned paddr, unsigned iaddr);
    ~i2c_port();

    void SetSDA(bool state);
    bool GetSDA();
    void SetSCL(bool state);
    bool GetSCL();
    void RaiseSCL();
    void Start();
    void Stop();

    bool ByteSent(unsigned b);
    bool ByteReceived(unsigned *b, bool do_ack);

  private:
    unsigned i2c_addr;    
};
