/*
   Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
  
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//	Bits en el registro de STATUS
#define PPAR_SELECT	3
#define PPAR_ERROR	3
#define PPAR_BUSY	7

//	Bits en el registro de CONTROL
#define PPAR_STATUS	1
#define PPAR_CONTROL	2

//	En 1 los bits que tienen que invertirse
#define PPAR_INV_STATUS	 0x80	// Para el puerto de STATUS
#define	PPAR_INV_CONTROL 0x0B	// Idem para el puerto de CONTROL

class par_port {
  public:
    par_port(unsigned int paddr);
    ~par_port();

    void SetData(unsigned int data);

    void SetDataBit(int bitnr, int new_state);
    void SetControlBit(int bitnr, int new_state);
    int  GetDataBit(int bitnr);
    int  GetControlBit(int bitnr);
    int  GetStatusBit(int bitnr);

  private:
    unsigned int  addr;
    unsigned char ctl_state,
    		  data_state;
};
