/*
 *  Copyright (C) 2009- John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* NOTE: This program has to be run as root! Else it will cause
 * a segmentation error. (It's probably possible to run it as sudo)
 */

#include <stdio.h>
#include <unistd.h>

typedef unsigned char byte;
typedef bool (*compare_func)(byte);

byte input = 0;

#define RESOLUCION	6
#define PARPORT		0x378
#define PAR_OUT		(PARPORT+0)
#define PAR_IN  	(PARPORT+1)
#define BUSY_BIT	7

#ifdef __linux__
	#include <sys/io.h>
	#define READ_COMPARATOR (inb(PAR_IN) & (1 << BUSY_BIT))
	#define OUTPUT_VALUE(v)	outb(v, PAR_OUT)
	#define DA_DELAY	usleep(100)
#else
	#define	READ_COMPARATOR (inportb(PAR_IN) & (1 << BUSY_BIT))
	#define	OUTPUT_VALUE(v)	outportb(PAR_OUT, v)
	#define	DA_DELAY	delay(1)
#endif

bool
compare_test(byte newval)
{
  return (newval > input);
}

bool
comparator(byte newval)
{
  return READ_COMPARATOR;
}

byte
succ_approx(compare_func DA_larger)
{
  byte step, result;

  #ifdef __LINUX__
  if (ioperm(PARPORT, 2, 1) < 0) {
    printf("Cannot obtain control of parallel port\n");
    _exit(1);
  }
  #endif
  result = 0;
  for (step = 1 << (RESOLUCION-1); step > 0; step >>= 1) {
    result += step;
    OUTPUT_VALUE(result);
    DA_DELAY;
    if (DA_larger(result)) 
      result -= step;
  }
  #ifdef __LINUX__
  ioperm(PARPORT, 2, 0);
  #endif

  return result;
}

int
main(void)
{
  for (input = 0; input < 64; input++) {
    printf("Input: %3d  Result: %3d\n", input, succ_approx(compare_test));
  }

  return 0;
}
