#!/usr/bin/env python

import xml.etree.ElementTree as et

with open("6-1.circ", "r") as file:
  data = file.read()
  
dom = et.fromstring(data)

print dom.tag				# Muesta el tag de raiz del documento

for element in dom:			# Muestra todos los elementos
  print element
  
for el in dom.iter('element'):		# Intera sobre los 'hijos', recursivamente
  print el

for el in dom.iterfind('element'):	# Intera sobre los 'hijos', sin recursion
  print el

version = dom.find('version')
print version

v_attr = version.attrib			# diccionario con atributos de version
print v_attr['major']
print v_attr['minor']

for key, val  in version.items():	# otra forma de acceder a los atributos
  print key, val

for el in dom.iterfind('element'):	# Para cada elemento
  print 'element'			# Imprimir un titulo,
  print '  ' + el.find('val1').text	# y el valor del elemento
  print '  ' + el.find('val1').text
  


dom = et.parse("6-1.load");
  
for load in dom.iterfind('load'):
  print "load:"
  for key, val in load.items():
    print '  %s: %s' % (key, val)
